/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.ArrayList;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiSubworldEdit
extends GuiScreenMinimap
implements BooleanConsumer {
    private Screen parent;
    private IWaypointManager waypointManager;
    private ArrayList<String> knownSubworldNames;
    private String originalSubworldName = "";
    private String currentSubworldName = "";
    private TextFieldWidget subworldNameField;
    private Button doneButton;
    private Button deleteButton;
    private boolean deleteClicked = false;

    public GuiSubworldEdit(Screen parent, IVoxelMap master, String subworldName) {
        this.parent = parent;
        this.waypointManager = master.getWaypointManager();
        this.originalSubworldName = subworldName;
        this.knownSubworldNames = new ArrayList<String>(this.waypointManager.getKnownSubworldNames());
    }

    public void tick() {
        this.subworldNameField.func_146178_a();
    }

    public void init() {
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.getButtonList().clear();
        this.subworldNameField = new TextFieldWidget(this.getFontRenderer(), this.getWidth() / 2 - 100, this.getHeight() / 6 + 0 + 13, 200, 20, "");
        this.setFocused((IGuiEventListener)this.subworldNameField);
        this.subworldNameField.func_146195_b(true);
        this.subworldNameField.func_146180_a(this.originalSubworldName);
        this.addButton((Widget)this.subworldNameField);
        this.doneButton = new Button(this.getWidth() / 2 - 155, this.getHeight() / 6 + 168, 150, 20, I18nUtils.getString("gui.done", new Object[0]), null){

            public void onPress() {
                GuiSubworldEdit.this.changeName();
            }
        };
        this.addButton((Widget)this.doneButton);
        this.addButton((Widget)new Button(this.getWidth() / 2 + 5, this.getHeight() / 6 + 168, 150, 20, I18nUtils.getString("gui.cancel", new Object[0]), null){

            public void onPress() {
                GuiSubworldEdit.this.getMinecraft().func_147108_a(GuiSubworldEdit.this.parent);
            }
        });
        int buttonListY = this.getHeight() / 6 + 82 + 6;
        this.deleteButton = new Button(this.getWidth() / 2 - 50, buttonListY + 24, 100, 20, I18nUtils.getString("selectServer.delete", new Object[0]), null){

            public void onPress() {
                GuiSubworldEdit.this.delete();
            }
        };
        this.addButton((Widget)this.deleteButton);
        this.doneButton.active = this.isNameAcceptable();
        this.deleteButton.active = this.originalSubworldName.equals(this.subworldNameField.func_146179_b());
    }

    @Override
    public void removed() {
        this.getMinecraft().field_195559_v.func_197967_a(false);
    }

    private void changeName() {
        if (!this.currentSubworldName.equals(this.originalSubworldName)) {
            this.waypointManager.changeSubworldName(this.originalSubworldName, this.currentSubworldName);
        }
        this.getMinecraft().func_147108_a(this.parent);
    }

    private void delete() {
        this.deleteClicked = true;
        String var4 = I18nUtils.getString("worldmap.subworld.deleteconfirm", new Object[0]);
        TranslationTextComponent explanation = new TranslationTextComponent("selectServer.deleteWarning", new Object[]{this.originalSubworldName});
        String var6 = I18nUtils.getString("selectServer.deleteButton", new Object[0]);
        String var7 = I18nUtils.getString("gui.cancel", new Object[0]);
        ConfirmScreen var8 = new ConfirmScreen((BooleanConsumer)this, (ITextComponent)new StringTextComponent(var4), (ITextComponent)explanation, var6, var7);
        this.getMinecraft().func_147108_a((Screen)var8);
    }

    public void accept(boolean par1) {
        if (this.deleteClicked) {
            this.deleteClicked = false;
            if (par1) {
                this.waypointManager.deleteSubworld(this.originalSubworldName);
            }
            this.getMinecraft().func_147108_a(this.parent);
        }
    }

    public boolean keyPressed(int keysm, int scancode, int b) {
        boolean OK = super.keyPressed(keysm, scancode, b);
        boolean acceptable = this.isNameAcceptable();
        this.doneButton.active = this.isNameAcceptable();
        this.deleteButton.active = this.originalSubworldName.equals(this.subworldNameField.func_146179_b());
        if ((keysm == 257 || keysm == 335) && acceptable) {
            this.changeName();
        }
        return OK;
    }

    public boolean charTyped(char character, int keycode) {
        boolean OK = super.charTyped(character, keycode);
        boolean acceptable = this.isNameAcceptable();
        this.doneButton.active = this.isNameAcceptable();
        this.deleteButton.active = this.originalSubworldName.equals(this.subworldNameField.func_146179_b());
        if (character == '\r' && acceptable) {
            this.changeName();
        }
        return OK;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int par3) {
        this.subworldNameField.mouseClicked(mouseX, mouseY, par3);
        return super.mouseClicked(mouseX, mouseY, par3);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.drawMap();
        this.renderBackground();
        this.drawCenteredString(this.getFontRenderer(), I18nUtils.getString("worldmap.subworld.edit", new Object[0]), this.getWidth() / 2, 20, 0xFFFFFF);
        this.drawString(this.getFontRenderer(), I18nUtils.getString("worldmap.subworld.name", new Object[0]), this.getWidth() / 2 - 100, this.getHeight() / 6 + 0, 0xA0A0A0);
        this.subworldNameField.render(mouseX, mouseY, partialTicks);
        super.render(mouseX, mouseY, partialTicks);
    }

    private boolean isNameAcceptable() {
        boolean acceptable = true;
        this.currentSubworldName = this.subworldNameField.func_146179_b();
        acceptable = acceptable && this.currentSubworldName.length() > 0;
        acceptable = acceptable && (this.currentSubworldName.equals(this.originalSubworldName) || !this.knownSubworldNames.contains(this.currentSubworldName));
        return acceptable;
    }
}

