/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.gui.GuiAddWaypoint;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiSlotMinimap;
import com.mamiyaotaru.voxelmap.interfaces.IDimensionManager;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.util.text.TranslationTextComponent;

class GuiSlotDimensions
extends GuiSlotMinimap<DimensionItem> {
    private IDimensionManager dimensionManager;
    final GuiAddWaypoint parentGui;
    private ArrayList<DimensionItem> dimensions;

    public GuiSlotDimensions(GuiAddWaypoint par1GuiWaypoints) {
        super(Minecraft.func_71410_x(), 101, par1GuiWaypoints.getHeight(), par1GuiWaypoints.getHeight() / 6 + 82 + 6, par1GuiWaypoints.getHeight() / 6 + 164 + 3, 18);
        this.parentGui = par1GuiWaypoints;
        this.setSlotWidth(88);
        this.setLeftPos(this.parentGui.getWidth() / 2);
        this.setRenderSelection(false);
        this.setShowTopBottomBG(false);
        this.setShowSlotBG(false);
        this.dimensionManager = this.parentGui.master.getDimensionManager();
        this.dimensions = new ArrayList();
        DimensionItem first = null;
        for (DimensionContainer dim : this.dimensionManager.getDimensions()) {
            DimensionItem item = new DimensionItem(this.parentGui, dim);
            this.dimensions.add(item);
            if (!dim.equals(this.parentGui.waypoint.dimensions.first())) continue;
            first = item;
        }
        this.dimensions.forEach(arg_0 -> ((GuiSlotDimensions)this).addEntry(arg_0));
        if (first != null) {
            this.ensureVisible((AbstractList.AbstractListEntry)first);
        }
    }

    public void setSelected(DimensionItem item) {
        super.setSelected((AbstractList.AbstractListEntry)item);
        if (this.getSelected() instanceof DimensionItem) {
            NarratorChatListener.field_193643_a.func_216864_a(new TranslationTextComponent("narrator.select", new Object[]{((DimensionItem)((DimensionItem)this.getSelected())).dim.name}).getString());
        }
        this.parentGui.setSelectedDimension(item.dim);
    }

    protected boolean isSelectedItem(int par1) {
        return this.dimensions.get(par1).dim.equals(this.parentGui.selectedDimension);
    }

    public void renderBackground() {
    }

    protected void renderHoleBackground(int par1, int par2, int par3, int par4) {
    }

    public class DimensionItem
    extends ExtendedList.AbstractListEntry<DimensionItem> {
        private final GuiAddWaypoint parentGui;
        private final DimensionContainer dim;

        protected DimensionItem(GuiAddWaypoint waypointScreen, DimensionContainer dim) {
            this.parentGui = waypointScreen;
            this.dim = dim;
        }

        public void render(int slotIndex, int slotYPos, int leftEdge, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean mouseOver, float partialTicks) {
            String name = this.dim.name;
            if (name.equals("notLoaded") || name.equals("failedToLoad")) {
                name = "dimension " + this.dim.id + "(" + Minecraft.func_71410_x().field_71441_e.func_72863_F().getClass().getSimpleName() + ")";
            }
            this.parentGui.drawCenteredString(this.parentGui.getFontRenderer(), this.dim.getDisplayName(), this.parentGui.getWidth() / 2 + GuiSlotDimensions.this.slotWidth / 2, slotYPos + 3, 0xFFFFFF);
            int padding = 4;
            int iconWidth = 16;
            leftEdge = this.parentGui.getWidth() / 2;
            int width = GuiSlotDimensions.this.slotWidth;
            if (mouseX >= leftEdge + padding && mouseY >= slotYPos && mouseX <= leftEdge + width + padding && mouseY <= slotYPos + GuiSlotDimensions.this.itemHeight) {
                String tooltip = null;
                tooltip = !this.parentGui.popupOpen() && mouseX >= leftEdge + width - iconWidth - padding && mouseX <= leftEdge + width ? (this.parentGui.waypoint.dimensions.contains(this.dim) ? I18nUtils.getString("minimap.waypoints.dimension.applies", new Object[0]) : I18nUtils.getString("minimap.waypoints.dimension.notapplies", new Object[0])) : null;
                GuiAddWaypoint.setTooltip(this.parentGui, tooltip);
            }
            GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            GLUtils.img("textures/gui/container/beacon.png");
            int xOffset = this.parentGui.waypoint.dimensions.contains(this.dim) ? 91 : 113;
            int yOffset = 222;
            this.parentGui.blit(leftEdge + width - iconWidth, slotYPos - 2, xOffset, yOffset, 16, 16);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
            GuiSlotDimensions.this.setSelected(this);
            int leftEdge = this.parentGui.getWidth() / 2;
            int padding = 4;
            int iconWidth = 16;
            int width = GuiSlotDimensions.this.slotWidth;
            if (mouseX >= (double)(leftEdge + width - iconWidth - padding) && mouseX <= (double)(leftEdge + width)) {
                this.parentGui.toggleDimensionSelected();
            } else if (GuiSlotDimensions.this.doubleclick) {
                this.parentGui.toggleDimensionSelected();
            }
            return true;
        }
    }
}

