/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.RadarSettingsManager;
import com.mamiyaotaru.voxelmap.gui.GuiMobs;
import com.mamiyaotaru.voxelmap.gui.overridden.EnumOptionsMinimap;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiOptionButtonMinimap;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;

public class GuiRadarOptions
extends GuiScreenMinimap {
    private static final EnumOptionsMinimap[] relevantOptionsFull = new EnumOptionsMinimap[]{EnumOptionsMinimap.SHOWRADAR, EnumOptionsMinimap.RADARMODE, EnumOptionsMinimap.SHOWHOSTILES, EnumOptionsMinimap.SHOWNEUTRALS, EnumOptionsMinimap.SHOWPLAYERS, EnumOptionsMinimap.SHOWPLAYERNAMES, EnumOptionsMinimap.SHOWPLAYERHELMETS, EnumOptionsMinimap.SHOWMOBHELMETS, EnumOptionsMinimap.RADARFILTERING, EnumOptionsMinimap.RADAROUTLINES};
    private static final EnumOptionsMinimap[] relevantOptionsSimple = new EnumOptionsMinimap[]{EnumOptionsMinimap.SHOWRADAR, EnumOptionsMinimap.RADARMODE, EnumOptionsMinimap.SHOWHOSTILES, EnumOptionsMinimap.SHOWNEUTRALS, EnumOptionsMinimap.SHOWPLAYERS, EnumOptionsMinimap.SHOWFACING};
    private static EnumOptionsMinimap[] relevantOptions;
    private final Screen parent;
    private final RadarSettingsManager options;
    protected String screenTitle = "Radar Options";

    public GuiRadarOptions(Screen parent, IVoxelMap master) {
        this.parent = parent;
        this.options = master.getRadarOptions();
    }

    public void init() {
        this.getButtonList().clear();
        this.children.clear();
        int var2 = 0;
        this.screenTitle = I18nUtils.getString("options.minimap.radar.title", new Object[0]);
        relevantOptions = this.options.radarMode == this.options.FULL ? relevantOptionsFull : relevantOptionsSimple;
        for (int t = 0; t < relevantOptions.length; ++t) {
            final EnumOptionsMinimap option = relevantOptions[t];
            GuiOptionButtonMinimap optionButton = new GuiOptionButtonMinimap(this.getWidth() / 2 - 155 + var2 % 2 * 160, this.getHeight() / 6 + 24 * (var2 >> 1), option, this.options.getKeyText(option), null){

                @Override
                public void onPress() {
                    GuiRadarOptions.this.actionPerformed(this, option.returnEnumOrdinal());
                }
            };
            this.addButton((Widget)optionButton);
            ++var2;
        }
        for (Widget buttonObj : this.getButtonList()) {
            if (!(buttonObj instanceof GuiOptionButtonMinimap)) continue;
            GuiOptionButtonMinimap button = (GuiOptionButtonMinimap)buttonObj;
            if (!button.returnEnumOptions().equals((Object)EnumOptionsMinimap.SHOWRADAR)) {
                button.active = this.options.showRadar;
            }
            if (button.returnEnumOptions().equals((Object)EnumOptionsMinimap.SHOWPLAYERS)) {
                button.active = button.active && (this.options.radarAllowed != false || this.options.radarPlayersAllowed != false);
                continue;
            }
            if (button.returnEnumOptions().equals((Object)EnumOptionsMinimap.SHOWNEUTRALS) || button.returnEnumOptions().equals((Object)EnumOptionsMinimap.SHOWHOSTILES)) {
                button.active = button.active && (this.options.radarAllowed != false || this.options.radarMobsAllowed != false);
                continue;
            }
            if (button.returnEnumOptions().equals((Object)EnumOptionsMinimap.SHOWPLAYERHELMETS) || button.returnEnumOptions().equals((Object)EnumOptionsMinimap.SHOWPLAYERNAMES)) {
                button.active = button.active && this.options.showPlayers && (this.options.radarAllowed != false || this.options.radarPlayersAllowed != false);
                continue;
            }
            if (!button.returnEnumOptions().equals((Object)EnumOptionsMinimap.SHOWMOBHELMETS)) continue;
            button.active = !(!button.active || !this.options.showNeutrals && !this.options.showHostiles || this.options.radarAllowed == false && this.options.radarMobsAllowed == false);
        }
        if (this.options.radarMode == this.options.FULL) {
            this.addButton((Widget)new Button(this.getWidth() / 2 - 155, this.getHeight() / 6 + 144 - 6, 150, 20, I18nUtils.getString("options.minimap.radar.selectmobs", new Object[0]), null){

                public void onPress() {
                    GuiRadarOptions.this.actionPerformed(this, 101);
                }
            });
        }
        this.addButton((Widget)new Button(this.getWidth() / 2 - 100, this.getHeight() / 6 + 168, 200, 20, I18nUtils.getString("gui.done", new Object[0]), null){

            public void onPress() {
                GuiRadarOptions.this.actionPerformed(this, 200);
            }
        });
    }

    protected void actionPerformed(Button buttonClicked, int id) {
        if (buttonClicked.active) {
            if (id < 100 && buttonClicked instanceof GuiOptionButtonMinimap) {
                this.options.setOptionValue(((GuiOptionButtonMinimap)buttonClicked).returnEnumOptions(), 1);
                if (((GuiOptionButtonMinimap)buttonClicked).returnEnumOptions().equals((Object)EnumOptionsMinimap.RADARMODE)) {
                    this.init();
                    return;
                }
                buttonClicked.setMessage(this.options.getKeyText(EnumOptionsMinimap.getEnumOptions(id)));
                for (Widget buttonObj : this.getButtonList()) {
                    GuiOptionButtonMinimap button;
                    if (buttonObj instanceof GuiOptionButtonMinimap) {
                        button = (GuiOptionButtonMinimap)buttonObj;
                        if (!button.returnEnumOptions().equals((Object)EnumOptionsMinimap.SHOWRADAR)) {
                            button.active = this.options.showRadar;
                        }
                        if (button.returnEnumOptions().equals((Object)EnumOptionsMinimap.SHOWPLAYERS)) {
                            button.active = button.active && (this.options.radarAllowed != false || this.options.radarPlayersAllowed != false);
                            continue;
                        }
                        if (button.returnEnumOptions().equals((Object)EnumOptionsMinimap.SHOWNEUTRALS) || button.returnEnumOptions().equals((Object)EnumOptionsMinimap.SHOWHOSTILES)) {
                            button.active = button.active && (this.options.radarAllowed != false || this.options.radarMobsAllowed != false);
                            continue;
                        }
                        if (button.returnEnumOptions().equals((Object)EnumOptionsMinimap.SHOWPLAYERHELMETS) || button.returnEnumOptions().equals((Object)EnumOptionsMinimap.SHOWPLAYERNAMES)) {
                            button.active = button.active && this.options.showPlayers && (this.options.radarAllowed != false || this.options.radarPlayersAllowed != false);
                            continue;
                        }
                        if (!button.returnEnumOptions().equals((Object)EnumOptionsMinimap.SHOWMOBHELMETS)) continue;
                        button.active = !(!button.active || !this.options.showNeutrals && !this.options.showHostiles || this.options.radarAllowed == false && this.options.radarMobsAllowed == false);
                        continue;
                    }
                    if (!(buttonObj instanceof Button)) continue;
                    button = (Button)buttonObj;
                    if (id != 101) continue;
                    button.active = this.options.showRadar;
                }
            }
            if (id == 101) {
                this.getMinecraft().func_147108_a((Screen)new GuiMobs(this, this.options));
            }
            if (id == 200) {
                this.getMinecraft().func_147108_a(this.parent);
            }
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.drawMap();
        this.renderBackground();
        this.drawCenteredString(this.getFontRenderer(), this.screenTitle, this.getWidth() / 2, 20, 0xFFFFFF);
        super.render(mouseX, mouseY, partialTicks);
    }
}

